var version = 0.5;

var quote;
var background;
var silhouette;
var person;

var buttonsCreated=0;

var chuckValue = 0;
var vinValue = 1;
var tValue = 2;

// Refresh the forecast each time the widget is shown
if (window.widget)
{
    widget.onshow = onshow;
}

function onshow()
{
	//If this is the first time the widget is being there will be no preferences so set them all to on
	if(widget.preferenceForKey("chuck_enabled") == undefined)
	{
		widget.setPreferenceForKey("true", "chuck_enabled");
		widget.setPreferenceForKey("true", "vin_enabled");
		widget.setPreferenceForKey("true", "t_enabled");
	}

	getQuote();
	setup();
	if(!buttonsCreated)
	{
		createButtons();
	}	
	//checkForUpdate();
}

function getQuote()
{
	var ran_number=random(2);
	//ran_number=1;

	if(ran_number == chuckValue)
	{
		//These URLs are a pain as the official site keeps moving its RSS feed :(
		//var url = "http://www.4q.cc/chuck/rss.php";
		var url = "http://66.111.201.60/chuck/rss.php";

		var backup_url = "http://www.noisymime.org/software/widgets/facts/chuck.rss";
		background = "Images/chuck.png";
		silhouette = "Images/chuck_sil.png";
		person = "Chuck Norris";
	}
	if(ran_number == vinValue)
	{
        	//var url = "http://www.4q.cc/vin/rss.php";
		var url = "http://66.111.201.60/vin/rss.php";
		var backup_url = "http://www.noisymime.org/software/widgets/facts/vin.rss";
		background = "Images/vin.png";
		silhouette = "Images/vin_sil.png";
		person = "Vin Diesel";
	}
	if(ran_number == tValue)
	{
        	//var url = "http://www.4q.cc/t/rss.php";
		var url = "http://66.111.201.60/t/rss.php";
		var backup_url = "http://www.noisymime.org/software/widgets/facts/t.rss";
		background = "Images/t.png";
		silhouette = "Images/t_sil.png";
		person = "Mr. T";
	}
	
	// Retrieve array of data
	var usageData = new XMLHttpRequest();
	usageData.open("GET", url, false);
	usageData.send(null);

	//Check if the RSS feed could be read
	if(usageData.status == 200)
	{
		xmlstring=usageData.responseText;

		// convert string to XML object
		var xmlobject = (new DOMParser()).parseFromString(xmlstring, "text/xml");

		// get a reference to the root-element "rss"
		var root = xmlobject.getElementsByTagName('rss')[0];
		// get reference to "channel" element
		var channels = root.getElementsByTagName("channel");
		// now get all "item" tags in the channel
		var items = channels[0].getElementsByTagName("item");
		// in the "item" we have a description, so get that
		quote = items[1].getElementsByTagName("title");
		quote = quote[0].firstChild.nodeValue;
	}
	else
	{
		//Try backup feed
		quote=backupFeed(backup_url);
		//Check whether there was a problem with the backup connection
		if(quote == 404)
		{
			quote="Could not connect to RSS feeds";
			background="Images/dead.png";
			person="Vin Diesel";
		}
	}

	//Check fact does not exceed maximum length
	var maxFactLength = 260;
	if(quote.length> maxFactLength)
	{
		quote = getQuote();
	}
	return quote;
}

function createButtons()
{
	//Buttons for flipping and updating etc
	createGenericButton(document.getElementById("infoButton"), "i", showBack);
	createGenericButton(document.getElementById("doneButton"), "Done", hideBack);

	buttonsCreated=1;

	//Also check for updates
	checkForUpdate();

}

function updatePrefs(changedBox)
{
	//Make sure at least one box is checked (Otherwise the random number generator loops forever looking for a valid number when there isn't one
	if(!document.getElementById("chkbox_chuck").checked && !document.getElementById("chkbox_vin").checked && !document.getElementById("chkbox_t").checked)
	{
		changedBox.checked = "true";
	}

	var chuck_status = document.getElementById("chkbox_chuck").checked;
	var vin_status = document.getElementById("chkbox_vin").checked;
	var t_status = document.getElementById("chkbox_t").checked;
	
	widget.setPreferenceForKey(chuck_status, "chuck_enabled");
	widget.setPreferenceForKey(vin_status, "vin_enabled");
	widget.setPreferenceForKey(t_status, "t_enabled");
}

function setup()
{
	document.getElementById("quoteText").innerText = quote;
	//document.getElementById("quoteText").innerText = document.getElementById("quoteText").innerText + document.getElementById("quoteText").clientHeight
	document.images["person"].src = background;
	document.images["silhouette"].src = silhouette;
	document.images["person"].style.position="absolute";
	document.images["silhouette"].style.position="absolute";

	//Setup preferences
	
	//Now update the values on the back panel to reflect the preferences
	document.getElementById("chkbox_chuck").checked = widget.preferenceForKey("chuck_enabled");
	document.getElementById("chkbox_vin").checked = widget.preferenceForKey("vin_enabled");
	document.getElementById("chkbox_t").checked = widget.preferenceForKey("t_enabled");


	//Adjust for picture size
	if(person=="Chuck Norris")
	{
		document.images["person"].style.top="55";
		document.images["person"].style.left="0";
		document.images["silhouette"].style.top="55";
		document.images["silhouette"].style.left="190";
	}
	if(person=="Vin Diesel")
	{
		document.images["person"].style.top="10";
		document.images["person"].style.left="40";
		document.images["silhouette"].style.top="10";
		document.images["silhouette"].style.left="190";
	}
	if(person=="Mr. T")
	{
		document.images["person"].style.top="10";
		document.images["person"].style.left="35";
		document.images["silhouette"].style.top="10";
		document.images["silhouette"].style.left="190";
	}
}

function refresh()
{
	quote = getQuote();
	setup();
}

//Flips panes from one to the other
function paneTransition(oldPaneName, newPaneName)
{
    var oldPane = document.getElementById(oldPaneName);
    var newPane = document.getElementById(newPaneName);
 
    if (window.widget)
        widget.prepareForTransition("ToBack");
 
    oldPane.style.display="none";
    newPane.style.display="block";
 
    if (window.widget)
        setTimeout ('widget.performTransition();', 0);
}

function showBack()
{
	paneTransition("front", "back");
}

function hideBack()
{
	paneTransition("back", "front");
}

function checkForUpdate()
{
	//paneTransition("back", "checkVersion");
	// Create link to website
	var url = "http://www.noisymime.org/software/widgets/facts/version";
	// Retrieve array of forecast data
	var versionData = new XMLHttpRequest();
	versionData.open("GET", url, false);
	versionData.setRequestHeader("Cache-Control", "no-cache");
	versionData.send(null);
	versionData = parseFloat(versionData.responseText);
	
	var updateText = document.getElementById("checkVersionText");
	if(versionData > version)
	{
		document.getElementById("updateText").style.visibility="visible";
	}
	else
	{
		document.getElementById("updateText").style.visibility="hidden";
	}
	
	// Store update time in prefs
	widget.setPreferenceForKey(timeNow,"lastUpdateTime");

}

//This function is called when the program cannot connect to the main RSS feed. It uses a backup one hosted on my own site
function backupFeed(url)
{
	// Retrieve array of forecast data
	var usageData = new XMLHttpRequest();
	usageData.open("GET", url, false);
	usageData.send(null);
	
	var random_fact=random(40); //(There's 40 random facts in each RSS on my site)

	//Check if the RSS feed could be read
	if(usageData.status == 200)
	{
		var xmlstring=usageData.responseText;

		// convert string to XML object
		var xmlobject = (new DOMParser()).parseFromString(xmlstring, "text/xml");

		// get a reference to the root-element "rss"
		var root = xmlobject.getElementsByTagName('rss')[0];
		// get reference to "channel" element
		var channels = root.getElementsByTagName("channel");
		// now get all "item" tags in the channel
		var items = channels[0].getElementsByTagName("item");
		// in the "item" we have a description, so get that
		quote = items[random_fact].getElementsByTagName("title");
		quote = quote[0].firstChild.nodeValue;
		
		return quote;
	}
	return 404;
}

//Stuff for the random numbers

random.m = 714025;
random.a = 4096;
random.c = 150889;
random.seed = (new Date()).getTime() % random.m;
function random(number) 
{

	random.seed = (random.seed * random.a + random.c) % random.m;

	var returnValue = Math.round((random.seed / random.m) * number);

	//Make sure return value is appropriate as per preferences
	//This is pretty dodgy but it works
	//Has a problem with infinite loops if no one is selected :(
	if(returnValue == chuckValue && !widget.preferenceForKey("chuck_enabled"))
	{
		returnValue = random(number);
	}
	if(returnValue == vinValue && !widget.preferenceForKey("vin_enabled"))
	{
		returnValue = random(number);
	}
	if(returnValue == tValue && !widget.preferenceForKey("t_enabled"))
	{
		returnValue = random(number);
	}

	return returnValue;
}
